/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.sass;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.css.CSSCodeScannerRuleBased;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class SassCodeScanner
extends CSSCodeScannerRuleBased {
    private IToken lastToken;
    private IDocument _document;

    protected List<IRule> createRules() {
        List rules = super.createRules();
        VariableWordRule variableRule = new VariableWordRule(new VariableWordDetector(), this.createToken("variable.other.sass"), true);
        rules.add(1, variableRule);
        return rules;
    }

    protected WordRule createAtWordsRule() {
        WordRule wordRule = super.createAtWordsRule();
        wordRule.addWord("@mixin", this.createToken("keyword.control.at-rule.mixin.sass"));
        wordRule.addWord("@include", this.createToken("keyword.control.at-rule.include.sass"));
        wordRule.addWord("@function", this.createToken("keyword.control.at-rule.function.sass"));
        wordRule.addWord("@while", this.createToken("keyword.control.at-rule.while.sass"));
        wordRule.addWord("@each", this.createToken("keyword.control.at-rule.each.sass"));
        wordRule.addWord("@for", this.createToken("keyword.control.at-rule.for.sass"));
        wordRule.addWord("@if", this.createToken("keyword.control.at-rule.if.sass"));
        wordRule.addWord("@warn", this.createToken("keyword.control.at-rule.warn.sass"));
        wordRule.addWord("@debug", this.createToken("keyword.control.at-rule.debug.sass"));
        wordRule.addWord("@extend", this.createToken("keyword.control.at-rule.extend.sass"));
        return wordRule;
    }

    public IToken nextToken() {
        IToken token = super.nextToken();
        if (token.isWhitespace()) {
            return token;
        }
        if (token.getData() instanceof String && ((String)token.getData()).contains(".css")) {
            String cssScopeName = (String)token.getData();
            String sassScopeName = cssScopeName.replaceAll("\\.css", "\\.sass");
            token = new Token((Object)sassScopeName);
        }
        if (this.lastToken != null && !"punctuation.separator.sass".equals(this.lastToken.getData()) && ("meta.selector.sass".equals(token.getData()) || "meta.property-value.sass".equals(token.getData()))) {
            String src = this.getSource(this.getTokenOffset(), this.getTokenLength());
            if (src.contains("\n") || src.contains("\r")) {
                if ("meta.selector.sass".equals(token.getData())) {
                    this.fInSelector = false;
                } else if ("meta.property-value.sass".equals(token.getData())) {
                    this.fInPropertyValue = false;
                }
                token = Token.WHITESPACE;
            }
        } else if (this.lastToken != null && ("keyword.control.at-rule.mixin.sass".equals(this.lastToken.getData()) || "keyword.control.at-rule.include.sass".equals(this.lastToken.getData()))) {
            token = new Token((Object)"entity.name.function.sass");
        }
        if (token.isOther()) {
            this.lastToken = token;
        }
        return token;
    }

    private String getSource(int tokenOffset, int tokenLength) {
        try {
            return this._document.get(tokenOffset, tokenLength);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected CharacterMapRule createPunctuatorsRule() {
        CharacterMapRule rule = super.createPunctuatorsRule();
        rule.add('=', this.createToken("punctuation.definition.entity.sass"));
        return rule;
    }

    protected String[] getPropertyNames() {
        String[] origCSS = super.getPropertyNames();
        HashSet<String> namespaced = new HashSet<String>();
        String[] stringArray = origCSS;
        int n = origCSS.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            StringTokenizer tokenizer = new StringTokenizer(name, "-");
            while (tokenizer.hasMoreTokens()) {
                namespaced.add(tokenizer.nextToken());
            }
            namespaced.add(name);
            ++n2;
        }
        ArrayList list = new ArrayList(namespaced);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return list.toArray(new String[list.size()]);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.lastToken = null;
        this._document = document;
        super.setRange(document, offset, length);
    }

    private static class VariableWordDetector
    implements IWordDetector {
        private VariableWordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '-' || c == '_';
        }

        public boolean isWordStart(char c) {
            return c == '!' || c == '$' || c == '=' || c == '+';
        }
    }

    private static final class VariableWordRule
    extends ExtendedWordRule {
        private VariableWordRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
            super(detector, defaultToken, ignoreCase);
        }

        protected boolean wordOK(String word, ICharacterScanner scanner) {
            return word.length() >= 2;
        }
    }
}

